package gov.va.med.mhv.vamf.util;

/**
 * Created by Michael Ramirez (michael@apothesource.com) on 2/7/17.
 */
public interface VamfJwtClaimsConstants {
	String USER_FIRST_NAME = "firstName";
	String USER_LAST_NAME = "lastName";
	String USER_MIDDLE_NAME = "middleName";
	String USER_VISTA_ACCESS_CODE = "accessCode";
	String AUTHENTICATION_AUTHORITY = "authenticationAuthority";
	String AUTHENTICATION_METHOD = "authenticationMethod";
	String AUTHENTICATED = "authenticated";
	String LAST_NAME = "lastName";
	String USER_ATTRIBUTES = "vamf.attrs";
	String MIDDLE_NAME = "middleName";
	String RIGHT_OF_ACCESS_ACCEPTED = "rightOfAccessAccepted";
	String VAMF_AUTH_ROLES = "vamf.auth.roles";
	String VAMF_AUTH_RESOURCES = "vamf.auth.resources";
	String VAMF_JWT_HEADER = "x-vamf-jwt";
	String AUTH_ROLES_CLAIM = "vamf.auth.roles";
	String AUTH_RESOURCE_CLAIM = "vamf.auth.resources";
	int JWT_LEEWAY_SECONDS = 60;
	String JWT_HMAC_SYSPROP = "gov.va.vamf.security.jwt.JWT_SECRET";
	String USER_EMAIL_ADDRESS = "email";
	String USER_SOURCE = "source";
	String SURROGATE_PATIENT = "patient";
	String ADDITIONAL_ATTRIBUTES = "attributes";
	String REGEX_PATIENT_EDIPI_RESOURCES = ".*(\\/)?patient[s]?\\/EDIPI\\/%s\\/.*";
	String REGEX_PATIENT_ICN_RESOURCES = ".*(\\/)?patient[s]?\\/(ICN\\/)?%s\\/.*";
	String AUTHORITY_EDIPI = "EDIPI";
	String AUTHORITY_ICN = "ICN";
	String VAMF_JWT_COOKIE_NAME = "vamfjwtv1";
	String VAMF_DEFAULT_ISSUER = "gov.va.vamf.userservice.v1";
	String USER_ICN = "icn";
	String USER_SSN = "ssn";
	String AUTH_ROLE_VETERAN = "veteran";
	String ID_TYPE = "idType";
	String USER_GENDER = "gender";
	String USER_BIRTH_DATE = "dateOfBirth";
	String MHV_SESSION_ID ="mhvSessionId";
}
